@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user shadow-sm">
                <div class="card-header d-flex justify-content-center border-0 pt-4">
                    <h3>Vendor Documents</h3>
                </div>
                <div class="card-body">
                    @if($type == "new" || $type == "resubmit")
                        <form method="POST" action="{{ url('vendor/submit/documents') }}" enctype='multipart/form-data'>
                            @csrf
                            @if($type == "new")
                                <h5><strong>Note: </strong><i>You are unauthorized till you submit all your documents.</i></h5>
                            @endif
                            
                            <br/>
                            
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="companyProfile" lang="es" name="companyProfile" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="companyProfile">Company Profile</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
<!--                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="company_profile_expiry_date" type="text" name="company_profile_expiry_date" placeholder="company profile expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>-->
                                </div>
                            </div>
                                
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="fssai" lang="es" name="fssai" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="fssai">Fssai</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" placeholder="Fssai expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                
                            <div class="row">    
                                <div class="col-md-6 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="gst" lang="es" name="gst" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="gst">GST</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="gst_expiry_date" type="text" name="gst_expiry_date" placeholder="GST expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="panCard" lang="es" name="panCard" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="panCard">Pan Card</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="pancard_expiry_date" type="text" name="pancard_expiry_date" placeholder="Pan Card expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="companyReg" lang="es" name="companyReg" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="companyReg">Company Registration</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="company_registration_expiry_date" type="text" name="company_registration_expiry_date" placeholder="Company Registration expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
<!--                            <div class="row">
                                <div class="col-md-4 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="pf" lang="es" name="pf" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="pf">Provident Fund</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" placeholder="Fssai expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>-->
                            
<!--                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="labourLicense" lang="es" name="labourLicense" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="labourLicense">Labour License</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" placeholder="Fssai expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>-->
                            
<!--                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="workerHealth" lang="es" name="workerHealth" onchange="putName(this);" accept=".doc, .pdf" required />
                                            <label class="custom-file-label" for="workerHealth">Worker Health</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="fssai_expiry_date" type="text" name="fssai_expiry_date" placeholder="Fssai expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>-->
                                
                            <div class="row">    
                                <div class="col-md-6 col-sm-12 pl-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="foodTestReport" lang="es" name="foodTestReport" onchange="putName(this);" accept=".doc, .pdf"  />
                                            <label class="custom-file-label" for="foodTestReport">Food Test Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="foodtest_expiry_date" type="text" name="foodtest_expiry_date" placeholder="Food Test expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="waterTestReport" lang="es" name="waterTestReport" onchange="putName(this);" accept=".doc, .pdf"  />
                                            <label class="custom-file-label" for="waterTestReport">Water Test Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="water_expiry_date" type="text" name="water_expiry_date" placeholder="Water expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="pestControlReport" lang="es" name="pestControlReport" onchange="putName(this);" accept=".doc, .pdf" />
                                            <label class="custom-file-label" for="pestControlReport">Pest Control Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="pest_control_expiry_date" type="text" name="pest_control_expiry_date" placeholder="Pest Control expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                                
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="kitchenAuditReport" lang="es" name="kitchenAuditReport" onchange="putName(this);" accept=".doc, .pdf" />
                                            <label class="custom-file-label" for="kitchenAuditReport">Kitchen Audit Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="kitchen_audit_expiry_date" type="text" name="kitchen_audit_expiry_date" placeholder="Kitchen Audit expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="policeVerificationReport" lang="es" name="policeVerificationReport" onchange="putName(this);" accept=".doc, .pdf" />
                                            <label class="custom-file-label" for="policeVerificationReport">Police Verification Report</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="police_verification_expiry_date" type="text" name="police_verification_expiry_date" placeholder="Police Verification Report expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 col-sm-12 px-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="cancelledCheque" lang="es" name="cancelledCheque" onchange="putName(this);" accept=".doc, .pdf"  />
                                            <label class="custom-file-label" for="cancelledCheque">Cancelled Cheque</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <div class="custom-file">
                                            <div class="input-group p-0 shadow-sm datepicker date">
                                                <input class="form-control shadow-sm" id="cc_expiry_date" type="text" name="cc_expiry_date" placeholder="Cancelled Cheque expiry date" autocomplete="off">
                                                <div class="input-group-append"><span class="input-group-text px-4"><i class="fa fa-calendar-o"></i></span></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row d-flex justify-content-center">
                                <div class="response">
                                    <button type="submit" class="wetasphalt w-100" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;">Submit Documents</button>
                                </div>
                            </div>
                        </form>
                    @elseif($type == "submitted")
                        <div>
                            @if(isset($elements) && !empty($elements))
                                <?php
                                    $url = asset('storage/app/public/documents/vendors').'/'.Auth::user()->id.'/';
                                ?>
                                <div class="row mb-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['companyProfile'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['companyProfile'] }}" target="_blank">Company Profile</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['fssai'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['fssai'] }}" target="_blank">Fssai</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['gst'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['gst'] }}" target="_blank">GST</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['panCard'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['panCard'] }}" target="_blank">Pan Card</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['companyReg'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['companyReg'] }}" target="_blank">Company Registration</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pf'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['pf'] }}" target="_blank">Provident Fund</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['labourLicense'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['labourLicense'] }}" target="_blank">Labour License</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['workerHealth'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['workerHealth'] }}" target="_blank">Worker Health</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['foodTestReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['foodTestReport'] }}" target="_blank">Food Test Report</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-4 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['waterTestReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['waterTestReport'] }}" target="_blank">Water Test Report</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['pestControlReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['pestControlReport'] }}" target="_blank">Pest Control Report</a>
                                        </button>
                                    </div>
                                    <div class="col-md-4 col-sm-12 pl-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['kitchenAuditReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['kitchenAuditReport'] }}" target="_blank">Kitchen Audit Report</a>
                                        </button>
                                    </div>
                                </div>
                                <div class="row mt-4">
                                    <div class="col-md-6 col-sm-12 pr-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['policeVerificationReport'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['policeVerificationReport'] }}" target="_blank">Police Verification Report</a>
                                        </button>
                                    </div>
                                    <div class="col-md-6 col-sm-12 px-md-1 d-flex justify-content-center">
                                        <button class="btn btn-info w-50" data-toggle="tooltip" title="{{ $elements['cancelledCheque'] }}">
                                            <a class="text-decoration-none text-white" href="{{ $url.$elements['cancelledCheque'] }}" target="_blank">Cancelled Cheque</a>
                                        </button>
                                    </div>
                                </div>
                            @else
                                <div class="badge badge-danger">Something Went Wrong!</div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
